# API网关

## 是什么？
是出现在系统边界上的一个面向API的、串行集中式的强管控服务，这里的边界是企业IT系统的边界。
API 网关模式意味着你要把API 网关放到你的微服务们的最前端，并且要让API 网关变成由应用所发起的每个请求的入口。这样就可以明显的简化客户端实现和微服务应用程序之间的沟通方式。

## 目的
一、 降低客户端复杂度
1. 使用方只需要知道一个统一的入口，不需要考虑后面更复杂的情况
2. 合并请求
3. 对客户端和服务端进行解耦，可以保持网关不变的情况下，升级服务端

## 背景
1. 微服务提供的API粒度通常与客户端的需求不同，微服务一般提供细粒度的API，也就是说客户端需要与多个服务进行交互。
2. 不同的客户端需要不同的数据，不同类型客户端的网络性能不同。
3. 服务的划分可能会随时间而变化，因此需要对客户端隐藏细节。

## 注意的问题
它们除了保证数据的交换之外，还需要实现对接入客户端的身份认证、防报文重放与防数据篡改、功能调用的业务鉴权、响应数据的脱敏、流量与并发控制，甚至基于API调用的计量或者计费。

## 功能点
#### 面向运行期
对客户端实现身份认证
通信会话的秘钥协商，报文的加密与解密
日常流控与应急屏蔽
内部响应报文的场景化裁剪
支持「前正后反模型」的集成框架
报文格式的转换
业务路由的支撑
客户端优先的超时机制
全局流水号的生成与应用
面向客户端支持HTTP DNS / Direct IP

#### 面向开发期
自助的沙盒测试环境
面向客户端友好的 SDK / Library以及示例
能够根据后端代码直接生成客户端业务代码框架
完善的报文描述能力（元数据），支撑配置型的报文裁剪

#### 面向运维与运营
支持面向接入方的独立部署与快速水平扩展
面向业务场景或合作伙伴的自助API开通
对外接口性能与线上环境故障定位自助平台

## 参考资料
* [微服务与API网关（上）: 为什么需要API网关？](http://blog.didispace.com/hzf-ms-apigateway-1/)
* [有赞API网关实践](https://tech.youzan.com/api-gateway-in-practice/)
* [官方文档](https://www.consul.io/)